package ws2006.Team4;

import robocode.*;
import java.awt.Color;
import java.io.*;

public class Dicht extends TeamRobot {
	//definiert die Schussstrke
	int firepower = 1;
	
	//Grundlegendes Bewegungsmuster
	public void run() {
		//Definiert die Farben des Bots im Normalzustand
		setColors(Color.magenta, Color.magenta, Color.magenta);
		while (true) {
		//Maximale Geschwindigkeit 7; fhrt 800 Einheiten im Kreis, danach 400 geradeaus
		setTurnLeft(800);
		setMaxVelocity(7);
		ahead(1200);
		}
	}	
	
	//Verhalten bei Sicht eines Robot
	public void onScannedRobot(ScannedRobotEvent e) {
		//berprft, ob Robot kein Teammitglied ist
		if(!isTeammate(e.getName()))
			{		
				//Feuerstrke 1 bei Energie kleiner 20 und Distanz 150, ansonsten kein Feuer
				if(getEnergy()<20 && e.getDistance()<150)
					fire(1);
		else {
			//Unterschiedliche Feuerstrke bei unterschiedlichen Distanzen
			if(e.getDistance()<200)
				//Bei Distanz unter 200, Feuerstrke 3
				fire(firepower+2);
			else if(e.getDistance()<400)
				//Bei Distanz zwischen 200 und 400 Feuerstrke 2 im Normalzustand
				fire(firepower+1);
			//Ansonsten Feuerstrke 1
			fire(firepower);
			}
		}
		else
		{
			//Wenn Teammitglied weniger entfernt als 150...
			if(e.getDistance() < 150)
			{
					//... Nachricht versenden, um Kollision zu vermeiden ...
					try {
					sendMessage("drei_promill.Hacke", "Kollision");
					} catch (IOException ex) {}
				//... und 150 zurckfahren.
				back(150);	
			}
		}
	}
	
	//Verhalten bei Ziel verfehlt
	public void onBulletMissed(BulletMissedEvent e) {
		//Optische Kennzeichnung
		setColors(Color.green, Color.green, Color.green);
		//Feuerstrke um 1 erhhen
		++firepower;
	}
	
	//Verhalten bei Ziel getroffen
	public void onBulletHit(BulletHitEvent e) {
		//Farben zurcksetzen
		setColors(Color.magenta, Color.magenta, Color.magenta);
		//Feuerstrke auf 1 zurcksetzen
		firepower = 1;
	}
	
	//Verhalten bei Robot gerammt
	public void onHitRobot(HitRobotEvent e) {
		//berprft, ob kein Teammitglied...
		if(!isTeammate(e.getName()))
		{
			//... dann in Richtung drehen, von der der Robot gerammt wurde...
			turnRight(e.getBearing());
			//... und mit maximaler Feuerstrke feuern...
			fire(3);
		}
		else
		{
		//... ansonsten 150 zurckfahren.
		back(150);	
		}
	}
	
	//Verhalten bei Kollision mit Wand
	public void onHitWall(HitWallEvent e) {
		//Dreht sich um den Winkel, auf den der Robot auf die Wand trifft, nach links ...
		setTurnLeft(e.getBearing());
		//... und fhrt 150 geradeaus.
		ahead(150);
	}
	
	//Verhalten bei Message erhalten
	public void onMessageReceived(MessageEvent event)
	{		
		//Wenn die Message Kollision lautet...
		if(event.getMessage().equals("Kollision"))		
		{	
			//... 150 zurckfahren.
			back(150);
		}
	}
	
	//Verhalten bei Sieg
	public void onWin(WinEvent e) {
		//Abwechselnd nach links und rechts drehen
		while(true) {
			turnLeft(50);
			turnRight(50);
		}
	}
}
