package ws2006.Knopper;
import robocode.*;
import java.awt.Color;

/*
 * Knoboter - a team robot by Klaus Knopper,
 * based on "MyFirstLeader" by Mathew Nelson
 * 
 * Looks around for enemies, follows and shoots them.
 */
public class Knoboter extends TeamRobot {
 public String currentEnemyName      = null;
 public double currentEnemyDistance  = 10000;
 public double radarTurnAngle        = 16;
 public int count                    = 0;
 
 public void run() {
  setAdjustGunForRobotTurn(true);  // Keep the gun still when we turn
  currentEnemyName = null;         // No current enemy
  // The only thing we do here is move the radar
  while (true) {
   if(currentEnemyName == null) {
    setColors(Color.green,Color.green,Color.green);
    turnRadarLeft(360);
    count = 0;
   } else {
    radarTurnAngle = -radarTurnAngle;
    turnRadarLeft((count==0?radarTurnAngle/2.0:radarTurnAngle)+getRadarTurnRemaining());
    count++;
    if(count>6) currentEnemyName = null;
   }
  }
 }

 public void onRobotDeath(RobotDeathEvent e) {
  if(currentEnemyName != null && e.getName().equals(currentEnemyName)) {
   // The robot we are trying to kill just died.
   // Force to select another one.
   currentEnemyName     = null;
   currentEnemyDistance = 10000;
   out.println("requiescat in pacem: " + currentEnemyName + ", searching for new target.");
   setColors(Color.yellow,Color.yellow,Color.yellow);
  }
 }
	
 // If this robot is closer to us, try to track him instead of the current one
 public void maybeTrackRobot(String name, double bearing, double distance, boolean priority) {
  boolean aligngun = false;
  // Don't fire on teammates
  if(isTeammate(name)) return;
  if(currentEnemyName == null) {
   aligngun=true; currentEnemyName = name;
   setColors(Color.red,Color.red,Color.red);
   out.println("New target: " + name);
  }
  if(priority) {
   if(!name.equals(currentEnemyName)) {
    aligngun=true; currentEnemyName = name;
    out.println("New priority target: " + name);
    setColors(Color.red,Color.red,Color.red);
   }
  }
  // Follow the name we are tracking, ignore all others
  if(!name.equals(currentEnemyName)) return;
  currentEnemyDistance = distance;
  setTurnGunRight(normalRelativeAngle(bearing+getHeading()-getGunHeading()));
  if(aligngun) {
   setTurnRadarRight(normalRelativeAngle(getGunHeading()-getRadarHeading()));
  }
  setTurnRight(bearing);
  // If our target is too far away, turn and move torward it.
  if(distance > 90) {
   setAhead(distance - 85);
  }
  // Our target is too close!  Back up.
  if (distance < 80) {
   setBack(15);
  }
 }

 public void smartFire(double strength) { if(getGunHeat()==0) setFire(strength); }

 public void onScannedRobot(ScannedRobotEvent e) {
  double bearingFromGun = normalRelativeAngle(e.getBearing() + getHeading() - getGunHeading());
  if(Math.abs(bearingFromGun)<5) { // Target is right in front of our gun
   // Check if Target is not moving too fast in a sideways direction,
   // don't waste bullets!
   if(e.getDistance() <= 90) smartFire(3);
   else if(e.getDistance() <= 100) smartFire(2);
   else if(e.getDistance() <= 200) smartFire(1);
  }
  if(currentEnemyName != null && currentEnemyName.equals(e.getName())) count=2; // We still keep trak of our target
  maybeTrackRobot(e.getName(),e.getBearing(),e.getDistance(),false);
 }

 public void onWin(WinEvent e) {
  setColors(Color.yellow,Color.yellow,Color.yellow);
  out.println("I won. :-)"); turnRight(3*360);
  stop(); }

 // Helper functions
 public double normalRelativeAngle(double angle) {
  if (angle > -180 && angle <= 180) return angle;
  double fixedAngle = angle;
  while (fixedAngle <= -180) fixedAngle += 360;
  while (fixedAngle > 180)   fixedAngle -= 360;
  return fixedAngle;
 }


 public void onHitByBullet(HitByBulletEvent e) {
  double direction = normalRelativeAngle(90 - e.getBearing());
  setTurnLeft(direction);
//  setTurnGunLeft(normalRelativeAngle(direction-getGunHeading()));
  setAhead(10);
 }
}
